

<?php $__env->startSection('content'); ?>
<div class="space-y-8">
    
    <div>
        
        <h1 class="text-3xl font-bold text-gray-800">Dashboard Kontraktor</h1>
        <p class="text-gray-500 mt-1">Ringkasan aktivitas proyek Anda.</p>
    </div>

    
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        
        <div class="bg-white p-6 rounded-lg shadow-sm transition-all duration-300 hover:shadow-md">
            <div class="flex justify-between items-start">
                <h2 class="text-sm font-medium text-gray-500">Proyek Berjalan</h2>
                <div class="bg-blue-100 p-3 rounded-full">
                    <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path></svg>
                </div>
            </div>
            <div class="mt-2">
                <p class="text-3xl font-bold text-gray-900"><?php echo e($proyekBerjalan); ?></p>
                <p class="text-xs text-gray-400 mt-1">Total proyek aktif saat ini.</p>
            </div>
        </div>
        
        <div class="bg-white p-6 rounded-lg shadow-sm transition-all duration-300 hover:shadow-md">
            <div class="flex justify-between items-start">
                <h2 class="text-sm font-medium text-gray-500">Proyek Selesai</h2>
                <div class="bg-green-100 p-3 rounded-full">
                    <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                </div>
            </div>
            <div class="mt-2">
                <p class="text-3xl font-bold text-gray-900"><?php echo e($proyekSelesai); ?></p>
                <p class="text-xs text-gray-400 mt-1">Telah diserahkan ke klien.</p>
            </div>
        </div>
        
        <div class="bg-white p-6 rounded-lg shadow-sm transition-all duration-300 hover:shadow-md">
             <div class="flex justify-between items-start">
                <h2 class="text-sm font-medium text-gray-500">Pengeluaran Bulan Ini</h2>
                <div class="bg-yellow-100 p-3 rounded-full">
                    <svg class="w-6 h-6 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v.01M12 6v-1m0 1H9m3 0h3m-3 1h.01M12 18h.01M12 18v-1m0 1H9m3 0h3m-3-1h.01M12 16v-1m0 1H9m3 0h3m-6 5H9m3 0h3m-3 0v-1m0 1v-1m0 1H6m6 0h6"></path></svg>
                </div>
            </div>
            <div class="mt-2">
                <p class="text-3xl font-bold text-gray-900">
                    <span class="text-2xl align-top text-gray-600">Rp. </span><?php echo e(number_format($pengeluaranBulanIni, 0, ',', '.')); ?>

                </p>
                <p class="text-xs text-gray-400 mt-1">Total biaya di bulan <?php echo e(now()->translatedFormat('F')); ?>.</p>
            </div>
        </div>
        
        <div class="bg-white p-6 rounded-lg shadow-sm transition-all duration-300 hover:shadow-md">
            <div class="flex justify-between items-start">
                <h2 class="text-sm font-medium text-gray-500">Jumlah Vendor</h2>
                <div class="bg-purple-100 p-3 rounded-full">
                    <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                </div>
            </div>
            <div class="mt-2">
                <p class="text-3xl font-bold text-gray-900"><?php echo e($totalVendors); ?></p>
                <p class="text-xs text-gray-400 mt-1">Partner material terdaftar.</p>
            </div>
        </div>
    </div>
    
    
    <div class="grid grid-cols-1 lg:grid-cols-5 gap-8">
        
        <div class="lg:col-span-2 bg-white p-6 rounded-lg shadow-sm">
            <h3 class="font-bold text-lg mb-4 text-gray-700">Laporan Keuangan</h3>
            
            <div class="space-y-4">
                <div class="flex justify-between items-center bg-green-50 p-4 rounded-lg">
                    <span class="font-medium text-green-800">Total Pemasukan</span>
                    <span class="font-bold text-green-800">Rp. <?php echo e(number_format($totalPemasukan, 0, ',', '.')); ?></span>
                </div>
                
                <div class="flex justify-between items-center bg-yellow-50 p-4 rounded-lg">
                    <span class="font-medium text-yellow-800">Total Pengeluaran</span>
                    <span class="font-bold text-yellow-800">Rp. <?php echo e(number_format($totalPengeluaran + $totalUpahTukang, 0, ',', '.')); ?></span>
                </div>
                
                <div class="flex justify-between items-center bg-red-50 p-4 rounded-lg">
                    <span class="font-medium text-red-800">Profit/Loss</span>
                    <span class="font-bold text-red-800">Rp. <?php echo e(number_format($profitLoss, 0, ',', '.')); ?></span>
                </div>
            </div>

            <div class="mt-6">
                <h4 class="font-semibold text-md mb-3 text-gray-600">Komposisi Pengeluaran</h4>
                <?php if($totalPengeluaran > 0 || $totalUpahTukang > 0): ?>
                    <div class="relative h-64 w-full max-w-sm mx-auto">
                        <canvas id="expensePieChart"></canvas>
                    </div>
                <?php else: ?>
                    <p class="text-center text-gray-500 text-sm">Belum ada data pengeluaran.</p>
                <?php endif; ?>
            </div>

        </div>
        
        
        <div class="lg:col-span-3 bg-white p-6 rounded-lg shadow-sm">
             <h3 class="font-bold text-lg mb-4 text-gray-700">Grafik Pengeluaran per Proyek</h3>
             <?php if($chartLabels->isNotEmpty()): ?>
                 <div class="relative h-96 w-full">
                     <canvas id="projectExpenseChart"></canvas>
                 </div>
             <?php else: ?>
                 <div class="flex items-center justify-center h-full text-center">
                     <p class="text-gray-500">Belum ada data pengeluaran yang terhubung ke proyek.</p>
                 </div>
             <?php endif; ?>
        </div>
    </div>

    
    <div class="grid grid-cols-1 gap-8">
        <div class="bg-white p-6 rounded-lg shadow-sm">
            <h3 class="font-bold text-lg mb-4 text-gray-700">Vendor Baru Ditambahkan</h3>
            <div class="overflow-x-auto">
                <table class="min-w-full">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="text-left py-2 px-4 text-sm font-semibold text-gray-600 uppercase">Nama Vendor</th>
                            <th class="text-left py-2 px-4 text-sm font-semibold text-gray-600 uppercase">Telepon</th>
                            <th class="text-left py-2 px-4 text-sm font-semibold text-gray-600 uppercase">Daerah</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        <?php $__empty_1 = true; $__currentLoopData = $recentVendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td class="py-3 px-4"><?php echo e($vendor->nama_vendor); ?></td>
                                
                                <td class="py-3 px-4">
                                    <?php if($vendor->nomor_telepon): ?>
                                        <a href="https://wa.me/<?php echo e('62' . ltrim($vendor->nomor_telepon, '0')); ?>" target="_blank" rel="noopener noreferrer" class="flex items-center text-blue-600 hover:text-blue-800 hover:underline">
                                            <span><?php echo e($vendor->nomor_telepon); ?></span>
                                            
                                            <svg class="w-4 h-4 ml-1.5" fill="currentColor" viewBox="0 0 24 24">
                                                <path d="M12.04 2C6.58 2 2.13 6.45 2.13 11.91C2.13 13.66 2.61 15.35 3.48 16.81L2.1 21.99L7.45 20.62C8.88 21.41 10.44 21.85 12.04 21.85C17.5 21.85 21.95 17.4 21.95 11.91C21.95 6.45 17.5 2 12.04 2ZM17.48 14.53C17.22 14.41 16.1 13.88 15.89 13.8C15.68 13.72 15.52 13.68 15.36 13.92C15.2 14.16 14.77 14.69 14.61 14.85C14.45 15.01 14.29 15.05 14.03 14.93C13.77 14.81 12.94 14.52 11.93 13.63C11.13 12.92 10.59 12.08 10.43 11.84C10.27 11.6 10.39 11.47 10.51 11.35C10.62 11.24 10.75 11.08 10.88 10.94C11 10.82 11.06 10.7 11.18 10.46C11.3 10.22 11.24 10.02 11.16 9.86C11.08 9.7 10.59 8.5 10.43 8.12C10.28 7.73 10.12 7.77 9.98 7.77C9.84 7.77 9.68 7.77 9.52 7.77C9.36 7.77 9.12 7.85 8.92 8.05C8.72 8.25 8.23 8.7 8.23 9.82C8.23 10.94 9.56 12.21 9.72 12.41C9.88 12.61 12.5 16.54 16.2 18.1C16.92 18.42 17.5 18.6 17.96 18.75C18.63 18.96 19.19 18.92 19.6 18.57C20.07 18.16 20.32 17.54 20.44 17.11C20.56 16.68 20.56 16.32 20.48 16.16C20.4 16 20.24 15.92 19.98 15.8C19.72 15.68 18.6 15.15 18.39 15.07C18.18 14.99 18.02 14.95 17.86 15.19C17.7 15.43 17.27 15.96 17.11 16.12C16.95 16.28 16.79 16.32 16.53 16.2C16.27 16.08 15.44 15.79 14.43 14.9C13.63 14.19 13.09 13.35 12.93 13.11C12.77 12.87 12.89 12.74 13.01 12.62C13.12 12.51 13.25 12.35 13.38 12.21C13.5 12.09 13.56 11.97 13.68 11.73C13.8 11.49 13.74 11.29 13.66 11.13C13.58 10.97 13.09 9.77 12.93 9.39C12.78 9 12.62 9.04 12.48 9.04C12.34 9.04 12.18 9.04 12.02 9.04C11.86 9.04 11.62 9.12 11.42 9.32C11.22 9.52 10.73 10 10.73 11.12C10.73 12.24 12.06 13.51 12.22 13.71C12.38 13.91 14.33 16.8 17.7 18.1Z" />
                                            </svg>
                                        </a>
                                    <?php else: ?>
                                        <?php echo e('-'); ?>

                                    <?php endif; ?>
                                </td>
                                <td class="py-3 px-4"><?php echo e($vendor->daerah ?? '-'); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                
                                <td colspan="3" class="py-4 text-center text-gray-500">Tidak ada data vendor.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    
    <div class="grid grid-cols-1 gap-8">
        <div class="bg-white p-6 rounded-lg shadow-sm">
            <h3 class="font-bold text-lg mb-4 text-gray-700">Tagihan Jatuh Tempo</h3>
            <div class="overflow-x-auto">
                <table class="min-w-full">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="text-left py-2 px-4 text-sm font-semibold text-gray-600 uppercase">Keterangan / Toko</th>
                            <th class="text-left py-2 px-4 text-sm font-semibold text-gray-600 uppercase">Proyek</th>
                            <th class="text-left py-2 px-4 text-sm font-semibold text-gray-600 uppercase">Total</th>
                            <th class="text-left py-2 px-4 text-sm font-semibold text-gray-600 uppercase">Status</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        <?php $__empty_1 = true; $__currentLoopData = $tagihanJatuhTempo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tagihan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $dueDate = \Carbon\Carbon::parse($tagihan->tanggal_bayar);
                                $diff = now()->startOfDay()->diffInDays($dueDate, false);
                            ?>
                            <tr>
                                <td class="py-3 px-4"><?php echo e($tagihan->toko); ?></td>
                                <td class="py-3 px-4"><?php echo e($tagihan->proyek->nama_proyek ?? 'N/A'); ?></td>
                                <td class="py-3 px-4">Rp. <?php echo e(number_format($tagihan->total, 0, ',', '.')); ?></td>
                                <td class="py-3 px-4">
                                    <?php if($diff < 0): ?>
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800">
                                            Terlambat <?php echo e(abs($diff)); ?> hari
                                        </span>
                                    <?php elseif($diff == 0): ?>
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800">
                                            Hari Ini
                                        </span>
                                    <?php else: ?>
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">
                                            <?php echo e($diff); ?> hari lagi
                                        </span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="4" class="py-4 text-center text-gray-500">Tidak ada tagihan yang akan jatuh tempo.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    
    <div class="grid grid-cols-1 gap-8">
        <div class="bg-white p-6 rounded-lg shadow-sm">
            <h3 class="font-bold text-lg mb-4 text-gray-700">Upah Tukang Belum Lunas</h3>
            <div class="overflow-x-auto">
                <table class="min-w-full">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="text-left py-2 px-4 text-sm font-semibold text-gray-600 uppercase">Nama Mandor</th>
                            <th class="text-left py-2 px-4 text-sm font-semibold text-gray-600 uppercase">Proyek</th>
                            <th class="text-left py-2 px-4 text-sm font-semibold text-gray-600 uppercase">Total Pembayaran</th>
                            <th class="text-left py-2 px-4 text-sm font-semibold text-gray-600 uppercase">Status</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        <?php $__empty_1 = true; $__currentLoopData = $tukangBelumLunas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tukang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td class="py-3 px-4"><?php echo e($tukang->nama_mandor ?? $tukang->nama_tukang ?? 'N/A'); ?></td>
                                <td class="py-3 px-4"><?php echo e($tukang->proyek->nama_proyek ?? 'N/A'); ?></td>
                                <td class="py-3 px-4">Rp. <?php echo e(number_format($tukang->total_pembayaran, 0, ',', '.')); ?></td>
                                <td class="py-3 px-4">
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800">
                                        <?php echo e($tukang->status_pembayaran); ?>

                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="4" class="py-4 text-center text-gray-500">Semua upah tukang sudah lunas.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Palet warna Bar Chart (Tidak berubah)
    const barColors = [
        'rgba(59, 130, 246, 0.7)', 'rgba(16, 185, 129, 0.7)',
        'rgba(245, 158, 11, 0.7)', 'rgba(139, 92, 246, 0.7)',
        'rgba(239, 68, 68, 0.7)', 'rgba(22, 163, 74, 0.7)',
        'rgba(217, 70, 239, 0.7)'
    ];
    const barBorderColors = [
        'rgba(59, 130, 246, 1)', 'rgba(16, 185, 129, 1)',
        'rgba(245, 158, 11, 1)', 'rgba(139, 92, 246, 1)',
        'rgba(239, 68, 68, 1)', 'rgba(22, 163, 74, 1)',
        'rgba(217, 70, 239, 1)'
    ];

    // Script Bar Chart (Tidak berubah)
    const ctxBar = document.getElementById('projectExpenseChart');
    if (ctxBar) {
        const chartData = <?php echo json_encode($chartValues); ?>;
        if (chartData.length > 0) {
            new Chart(ctxBar, {
                type: 'bar',
                data: {
                    labels: <?php echo json_encode($chartLabels); ?>,
                    datasets: [{
                        label: 'Total Pengeluaran',
                        data: chartData,
                        backgroundColor: barColors,
                        borderColor: barBorderColors,
                        borderWidth: 1,
                        borderRadius: 5
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                callback: function(value) {
                                    return 'Rp. ' + new Intl.NumberFormat('id-ID').format(value);
                                }
                            }
                        },
                        x: {
                            ticks: {
                                callback: function(value) {
                                    const label = this.getLabelForValue(value);
                                    if (label.length > 20) {
                                        return label.substring(0, 20) + '...';
                                    }
                                    return label;
                                },
                                autoSkip: false,
                                maxRotation: 45,
                                minRotation: 30
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: false
                        },
                        tooltip: {
                            callbacks: {
                                title: function(tooltipItems) {
                                    return tooltipItems[0].chart.data.labels[tooltipItems[0].dataIndex];
                                }
                            }
                        }
                    }
                }
            });
        }
    }

    // Script Pie Chart (Tidak berubah)
    const ctxPie = document.getElementById('expensePieChart');
    if (ctxPie) {
        const totalPengeluaran = <?php echo e($totalPengeluaran); ?>;
        const totalUpahTukang = <?php echo e($totalUpahTukang); ?>;

        if (totalPengeluaran > 0 || totalUpahTukang > 0) {
            new Chart(ctxPie, {
                type: 'doughnut',
                data: {
                    labels: ['Pengeluaran Material/Lainnya', 'Upah Tukang'],
                    datasets: [{
                        data: [totalPengeluaran, totalUpahTukang],
                        backgroundColor: [
                            'rgba(239, 68, 68, 0.7)', // Merah
                            'rgba(245, 158, 11, 0.7)' // Kuning
                        ],
                        borderColor: [
                            'rgba(239, 68, 68, 1)',
                            'rgba(245, 158, 11, 1)'
                        ],
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'bottom',
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    let label = context.label || '';
                                    let value = context.raw;
                                    let percentage = (value / context.chart.getDatasetMeta(0).total * 100).toFixed(1);
                                    return `${label}: Rp. ${new Intl.NumberFormat('id-ID').format(value)} (${percentage}%)`;
                                }
                            }
                        }
                    }
                }
            });
        }
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\kontraktor-dashboard\resources\views/dashboard/index.blade.php ENDPATH**/ ?>