

<?php $__env->startSection('content'); ?>
<div class="space-y-8">
    <div>
        <h1 class="text-3xl font-bold text-gray-800">Buat Task Baru</h1>
        <p class="text-gray-500 mt-1">Isi detail di bawah untuk menugaskan pekerjaan kepada anggota Anda.</p>
    </div>

    <div class="bg-white p-8 rounded-xl shadow-md border border-gray-200 max-w-4xl mx-auto">
        <?php if($errors->any()): ?>
            <div class="mb-6 bg-red-50 border-l-4 border-red-400 text-red-700 p-4 rounded-lg" role="alert">
                <p class="font-bold">Oops! Ada beberapa kesalahan:</p>
                <ul class="mt-2 list-disc list-inside text-sm">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('tasks.store')); ?>" method="POST" class="space-y-6">
            <?php echo csrf_field(); ?>
            
            <div>
                <label for="title" class="block text-sm font-medium text-gray-700 mb-1">Judul Task <span class="text-red-500">*</span></label>
                <input type="text" name="title" id="title" class="w-full p-2 border border-gray-300 rounded-lg" value="<?php echo e(old('title')); ?>" placeholder="Contoh: Siapkan laporan PPh 21 untuk Proyek A" required>
            </div>

            <div>
                <label for="description" class="block text-sm font-medium text-gray-700 mb-1">Deskripsi (Opsional)</label>
                <textarea name="description" id="description" rows="4" class="w-full p-2 border border-gray-300 rounded-lg" placeholder="Tuliskan detail, poin-poin, atau instruksi di sini..."><?php echo e(old('description')); ?></textarea>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="proyek_id" class="block text-sm font-medium text-gray-700 mb-1">Proyek Terkait <span class="text-red-500">*</span></label>
                    <select name="proyek_id" id="proyek_id" class="w-full p-2 border border-gray-300 rounded-lg" required>
                        <option value="">-- Pilih Proyek --</option>
                        
                        <?php $__currentLoopData = $proyeks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $proyek): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($proyek->id_proyek); ?>" <?php echo e(old('proyek_id') == $proyek->id_proyek ? 'selected' : ''); ?>>
                                <?php echo e($proyek->nama_proyek); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                
                <div>
                    <label for="anggota_id" class="block text-sm font-medium text-gray-700 mb-1">Tugaskan Kepada (Anggota) <span class="text-red-500">*</span></label>
                    <select name="anggota_id" id="anggota_id" class="w-full p-2 border border-gray-300 rounded-lg" required>
                        <option value="">-- Pilih Anggota --</option>
                        
                        <?php $__currentLoopData = $anggota; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($member->id); ?>" <?php echo e(old('anggota_id') == $member->id ? 'selected' : ''); ?>>
                                <?php echo e($member->nama); ?> 
                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="priority" class="block text-sm font-medium text-gray-700 mb-1">Prioritas</label>
                    <select name="priority" id="priority" class="w-full p-2 border border-gray-300 rounded-lg">
                        <option value="Low" <?php echo e(old('priority') == 'Low' ? 'selected' : ''); ?>>Low</option>
                        <option value="Medium" <?php echo e(old('priority', 'Medium') == 'Medium' ? 'selected' : ''); ?>>Medium</option>
                        <option value="High" <?php echo e(old('priority') == 'High' ? 'selected' : ''); ?>>High</option>
                    </select>
                </div>
                <div>
                    <label for="due_date" class="block text-sm font-medium text-gray-700 mb-1">Jatuh Tempo (Opsional)</label>
                    <input type="date" name="due_date" id="due_date" class="w-full p-2 border border-gray-300 rounded-lg" value="<?php echo e(old('due_date')); ?>">
                </div>
            </div>
            
            
            <div class="flex justify-end space-x-4 pt-4 border-t border-gray-200 mt-6">
                <a href="<?php echo e(route('tasks.index')); ?>" class="px-4 py-2 bg-gray-300 text-gray-800 rounded-lg hover:bg-gray-400">Batal</a>
                <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">Simpan Task</button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.Project', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\kontraktor-dashboard\resources\views/tasks/create.blade.php ENDPATH**/ ?>