<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Laporan Proyek - {{ $proyek->nama_proyek }}</title>
    <style>
        body {
            font-family: 'Helvetica', sans-serif;
            font-size: 10px;
            line-height: 1.4;
            color: #333;
        }
        @page {
            margin: 40px 50px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header h1 {
            font-size: 20px;
            margin: 0;
            color: #222;
        }
        .header p {
            font-size: 12px;
            margin: 5px 0;
            color: #555;
        }
        .info-table {
            width: 100%;
            margin-bottom: 25px;
            border-collapse: collapse;
        }
        .info-table td {
            padding: 8px;
            border: 1px solid #ddd;
            font-size: 11px;
        }
        .info-table .label {
            background-color: #f9f9f9;
            font-weight: bold;
            width: 150px;
        }
        .summary-table {
            width: 100%;
            margin-bottom: 25px;
            border-collapse: collapse;
        }
        .summary-table th, .summary-table td {
            padding: 10px;
            border: 1px solid #ddd;
            text-align: right;
            font-size: 12px;
        }
        .summary-table th {
            background-color: #eee;
            text-align: left;
            font-weight: bold;
        }
        .summary-table .total-label {
            font-weight: bold;
        }
        .summary-table .profit {
            font-weight: bold;
            color: #006400;
        }
        .summary-table .loss {
            font-weight: bold;
            color: #d90000;
        }
        .content-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px; /* Kurangi margin bawah antar tabel group */
        }
        .content-table th, .content-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            vertical-align: top;
        }
        .content-table th {
            background-color: #f2f2f2;
            font-size: 11px;
            font-weight: bold;
            text-transform: uppercase;
        }
        .content-table td {
            font-size: 10px;
        }
        .content-table .text-right {
            text-align: right;
        }
        .content-table .sub-total-row td {
            font-weight: bold;
            background-color: #f9f9f9;
        }
        .total-row-summary { /* [TAMBAHAN] Style untuk total keseluruhan */
            font-weight: bold;
            background-color: #e5e7eb; /* bg-gray-200 */
            font-size: 12px;
            border-top: 2px solid #333;
        }
        .section-title {
            font-size: 16px;
            font-weight: bold;
            color: #333;
            margin-top: 30px;
            margin-bottom: 10px;
            border-bottom: 2px solid #ccc;
            padding-bottom: 5px;
        }
        /* [TAMBAHAN] Judul untuk setiap grup (Toko / Mandor) */
        .sub-section-title {
            font-size: 12px;
            font-weight: bold;
            color: #444;
            margin-top: 15px;
            margin-bottom: 5px;
            padding-left: 5px;
            border-left: 3px solid #007bff; /* Biru */
        }
        .footer {
            position: fixed;
            bottom: -30px;
            left: 0;
            right: 0;
            height: 30px;
            text-align: center;
            font-size: 9px;
            color: #888;
        }
        .footer .page-number:before {
            content: "Halaman " counter(page);
        }
        .page-break { /* [TAMBAHAN] Untuk memisahkan halaman jika perlu */
            page-break-after: always;
        }
    </style>
</head>
<body>

    <div class="footer">
        Dicetak pada: {{ $tanggalCetak ?? '' }} | Laporan Proyek | <span class="page-number"></span>
    </div>

    <div class="header">
        <h1>Laporan Rincian Proyek</h1>
        <p>{{ $proyek->nama_proyek }}</p>
    </div>

    <table class="info-table">
        <tr>
            <td class="label">Nama Proyek</td>
            <td>{{ $proyek->nama_proyek ?? '-' }}</td>
            <td class="label">Status</td>
            <td>{{ $proyek->status ?? '-' }}</td>
        </tr>
        <tr>
            <td class="label">Klien</td>
            <td>{{ $proyek->klien ?? '-' }}</td>
            <td class="label">Lokasi</td>
            <td>{{ $proyek->lokasi ?? '-' }}</td>
        </tr>
        <tr>
            <td class="label">Tanggal Mulai</td>
            <td>{{ $proyek->tanggal_mulai ? $proyek->tanggal_mulai->format('d F Y') : '-' }}</td>
            <td class="label">Tanggal Selesai</td>
            <td>{{ $proyek->tanggal_selesai ? $proyek->tanggal_selesai->format('d F Y') : '-' }}</td>
        </tr>
    </table>

    <h3 class="section-title">Ringkasan Finansial</h3>
    <table class="summary-table">
        <tr>
            <th>Deskripsi</th>
            <th style="width: 150px; text-align: right;">Jumlah</th>
        </tr>
        <tr>
            <td>Nilai Kontrak</td>
            <td class="text-right">Rp. {{ number_format($proyek->nilai_kontrak ?? 0, 0, ',', '.') }}</td>
        </tr>
        <tr>
            <td>Total Pengeluaran Material</td>
            <td class="text-right">(Rp. {{ number_format($proyek->total_pengeluaran ?? 0, 0, ',', '.') }})</td>
        </tr>
        <tr>
            <td>Total Upah Tukang</td>
            {{-- Data $proyek->total_upah sudah benar dari controller --}}
            <td class="text-right">(Rp. {{ number_format($proyek->total_upah ?? 0, 0, ',', '.') }})</td>
        </tr>
        <tr class="total-row">
            <td class="total-label">Total Biaya Proyek</td>
            <td class="text-right">(Rp. {{ number_format($totalBiaya ?? 0, 0, ',', '.') }})</td>
        </tr>
        <tr class="total-row">
            <td class="total-label">Profit / Loss</td>
            <td class="text-right {{ $profitLoss >= 0 ? 'profit' : 'loss' }}">
                Rp. {{ number_format($profitLoss ?? 0, 0, ',', '.') }}
            </td>
        </tr>
    </table>

    {{-- [MODIFIKASI] Rincian Pembayaran Material (Grouped by Toko) --}}
    <h3 class="section-title">Rincian Pembayaran Material</h3>
    @php
        $pengeluaransByToko = $proyek->pengeluarans->groupBy('toko');
    @endphp

    @forelse($pengeluaransByToko as $toko => $pengeluarans)
        <h4 class="sub-section-title">Vendor: {{ $toko ?: 'Toko Tidak Teridentifikasi' }}</h4>
        <table class="content-table">
            <thead>
                <tr>
                    <th>Tanggal</th>
                    <th>Deskripsi</th>
                    <th>Kategori</th>
                    <th>Status</th>
                    <th class="text-right">Jumlah</th>
                </tr>
            </thead>
            <tbody>
                @foreach($pengeluarans as $p)
                    <tr>
                        <td style="width: 70px;">{{ $p->tanggal_struk ? $p->tanggal_struk->format('d/m/Y') : '-' }}</td>
                        <td>{{ $p->items ?? '-' }}</td>
                        <td style="width: 80px;">{{ $p->kategori ?? '-' }}</td>
                        <td style="width: 70px;">{{ $p->status_bayar ?? '-' }}</td>
                        <td class="text-right" style="width: 90px;">Rp. {{ number_format($p->total ?? 0, 0, ',', '.') }}</td>
                    </tr>
                @endforeach
                {{-- Sub-Total per Toko --}}
                <tr class="sub-total-row">
                    <td colspan="4" class="text-right">Total ({{ $toko ?: 'Lain-lain' }})</td>
                    <td class="text-right">Rp. {{ number_format($pengeluarans->sum('total'), 0, ',', '.') }}</td>
                </tr>
            </tbody>
        </table>
    @empty
        <table class="content-table">
            <tr>
                <td colspan="5" style="text-align: center; padding: 20px;">- Tidak ada data pengeluaran material -</td>
            </tr>
        </table>
    @endforelse
    {{-- Total Keseluruhan Material --}}
    <table class="content-table">
        <tr class="total-row-summary">
            <td colspan="4" class="text-right">Total Keseluruhan Material</td>
            <td class="text-right" style="width: 90px;">Rp. {{ number_format($proyek->total_pengeluaran ?? 0, 0, ',', '.') }}</td>
        </tr>
    </table>
    

    {{-- [MODIFIKASI] Rincian Pembayaran Tukang (Grouped by Mandor) --}}
    <h3 class="section-title">Rincian Pembayaran Tukang</h3>
    @php
        // [PENTING] Group by 'nama_mandor'
        $tukangsByMandor = $proyek->tukangs->groupBy('nama_mandor');
    @endphp

    @forelse($tukangsByMandor as $mandor => $pembayaran)
        <h4 class="sub-section-title">Mandor: {{ $mandor ?: 'Mandor Tidak Teridentifikasi' }}</h4>
        <table class="content-table">
            <thead>
                <tr>
                    <th>Tgl. Jatuh Tempo</th>
                    <th>Status</th>
                    <th class="text-right">Jumlah</th>
                </tr>
            </thead>
            <tbody>
                @foreach($pembayaran as $t)
                    <tr>
                        <td style="width: 70px;">{{ $t->tanggal_jatuh_tempo ? $t->tanggal_jatuh_tempo->format('d/m/Y') : '-' }}</td>
                        <td style="width: 70px;">{{ $t->status_pembayaran ?? '-' }}</td>
                        <td class="text-right" style="width: 90px;">Rp. {{ number_format($t->total_pembayaran ?? 0, 0, ',', '.') }}</td>
                    </tr>
                @endforeach
                {{-- Sub-Total per Mandor --}}
                <tr class="sub-total-row">
                    <td colspan="2" class="text-right">Total ({{ $mandor ?: 'Lain-lain' }})</td>
                    {{-- [PENTING] Pastikan sum 'total_pembayaran' --}}
                    <td class="text-right">Rp. {{ number_format($pembayaran->sum('total_pembayaran'), 0, ',', '.') }}</td>
                </tr>
            </tbody>
        </table>
    @empty
         <table class="content-table">
            <tr>
                <td colspan="3" style="text-align: center; padding: 20px;">- Tidak ada data upah tukang -</td>
            </tr>
        </table>
    @endforelse
    {{-- Total Keseluruhan Tukang --}}
    <table class="content-table">
        <tr class="total-row-summary">
            <td colspan="2" class="text-right">Total Keseluruhan Upah Tukang</td>
            <td class="text-right" style="width: 90px;">Rp. {{ number_format($proyek->total_upah ?? 0, 0, ',', '.') }}</td>
        </tr>
    </table>

</body>
</html>