<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\AuthenticatedSessionController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ProyekController;
use App\Http\Controllers\PengeluaranController;
use App\Http\Controllers\TagihanController;
use App\Http\Controllers\TukangController;
use App\Http\Controllers\Owner\DashboardController as OwnerDashboardController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\InputdataController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\TeamController;
use App\Http\Controllers\TaskController;
use App\Http\Controllers\KlienController;
use App\Http\Controllers\AnggotaController;
use App\Http\Controllers\ProgressKlienController; // Pastikan ini ada

// ... Rute Login, Logout, dll. ...
Route::get('/', function () { return redirect()->route('login'); });
Route::middleware('guest')->group(function () {
    Route::get('login', [AuthenticatedSessionController::class, 'create'])->name('login');
    Route::post('login', [AuthenticatedSessionController::class, 'store'])->name('login.store');
});
Route::post('logout', [AuthenticatedSessionController::class, 'destroy'])->middleware('auth')->name('logout');


// === GRUP RUTE UNTUK ADMIN (KONTRAKTOR) ===
Route::middleware(['auth', 'role:admin'])->group(function () {

    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard.kontraktor');

    // Proyek
    Route::post('/proyek/{proyek}/tandai-selesai', [ProyekController::class, 'tandaiSelesai'])->name('proyek.tandaiSelesai');
    Route::resource('proyek', ProyekController::class);

    // Pengeluaran
    Route::get('/pengeluaran/export-pdf', [PengeluaranController::class, 'exportPDF'])->name('pengeluaran.exportPdf');
    Route::resource('pengeluaran', PengeluaranController::class)->except(['show']);

    // Tagihan (Vendor)
    Route::resource('tagihan', TagihanController::class);
    // Tukang
    Route::resource('tukang', TukangController::class);
    Route::post('/tukang/{tukang}/lunas', [TukangController::class, 'tandaiLunas'])->name('tukang.lunas');
    // Route untuk halaman laporan
    Route::get('/report', [ReportController::class, 'index'])->name('report.index');
    Route::get('/report/export/{id_proyek}', [ReportController::class, 'export'])->name('report.export');
    Route::get('/report/export-pdf/{id_proyek}', [ReportController::class, 'exportPdf'])->name('report.exportPdf');
    
    // [BARU] Route untuk halaman settings
    Route::get('/settings', [SettingController::class, 'index'])->name('settings.index');
    Route::post('/settings', [SettingController::class, 'update'])->name('settings.update');
    // [ROUTE BARU] Route untuk Tes SMTP
    Route::post('/settings/test-smtp', [SettingController::class, 'testSmtp'])->name('settings.test.smtp');

    // [DIUBAH] Rute untuk Fitur Input Data Awal (dengan 2-langkah review)
    Route::controller(InputdataController::class)->prefix('inputdata')->name('inputdata.')->group(function () {
        Route::get('/', 'index')->name('index'); // Halaman upload awal
        Route::get('/review', 'review')->name('review'); // Halaman review/penyesuaian
        Route::post('/upload-parse', 'parseUpload')->name('parse'); // Aksi upload dari halaman index
        Route::post('/process', 'process')->name('process'); // Aksi simpan dari halaman review
        Route::get('/download/{template}', 'downloadTemplate')->name('downloadTemplate'); // Aksi download template
    });

    // Route Users baru
    Route::resource('users', UserController::class);
    // [DIUBAH] RUTE TASK & TEAM KEMBALI KE GRUP ADMIN
    Route::resource('tasks', TaskController::class);
    Route::resource('teams', TeamController::class);
    Route::post('/tasks/{task}/update-status', [App\Http\Controllers\TaskController::class, 'updateStatus'])
        ->name('tasks.updateStatus')
        ->middleware(['auth', 'role:admin']); 
    // [BARU] Rute Manajemen Anggota (Hanya untuk Admin)
    Route::resource('anggota', AnggotaController::class);
    // DATA KLIEN 
    Route::resource('klien', KlienController::class);
    // ... Rute Klien lainnya ...
    Route::get('/klien/{id}/download/{field}', [KlienController::class, 'downloadFile'])->name('klien.downloadFile');
    Route::get('klien/export-excel', [KlienController::class, 'exportExcel'])->name('klien.export-excel');
    Route::get('klien/download-gambar/{id}/{index}', [KlienController::class, 'downloadGambar'])->name('klien.download-gambar');
    Route::get('klien/preview-gambar/{id}/{index}', [KlienController::class, 'previewGambar'])->name('klien.preview-gambar');
    Route::get('klien/hapus-gambar/{id}/{index}', [KlienController::class, 'hapusGambar'])->name('klien.hapus-gambar');
    Route::get('api/proyeks/available', [KlienController::class, 'getAvailableProyeks'])->name('api.proyeks.available');

    // === [PERBAIKAN DI SINI] ===
    // Rute untuk Halaman Progress Legalitas (Kanban)
    // [FIX] 'RouteMessage' diubah kembali menjadi 'Route'
    Route::get('/progress-legalitas', [ProgressKlienController::class, 'index'])
        ->name('progress.index')
        ->middleware('auth');

    // Rute BARU untuk menyimpan checklist per kartu (logika "Tambah List" yang baru)
    Route::post('/progress-legalitas/save', [ProgressKlienController::class, 'saveChecklist'])
        ->name('progress.checklist.save')
        ->middleware('auth');
    
    // Rute-rute lama sudah dihapus
    // === [AKHIR PERBAIKAN] ===
});

// === GRUP RUTE UNTUK USER BIASA (OWNER) ===
// Logic ini tetap sama dan aman
Route::middleware(['auth', 'role:user'])->group(function () {
    Route::get('/owner/dashboard', [OwnerDashboardController::class, 'index'])->name('dashboard.owner');
});


//require __DIR__.'/auth.php';