@extends('layouts.project')

@section('content')
<div class="space-y-8">
    <div>
        <h1 class="text-3xl font-bold text-gray-800">Edit Task</h1>
        <p class="text-gray-500 mt-1">Perbarui detail task: <span class="font-semibold">{{ $task->title }}</span></p>
    </div>

    <div class="bg-white p-8 rounded-xl shadow-md border border-gray-200 max-w-4xl mx-auto">
        @if ($errors->any())
            <div class="mb-6 bg-red-50 border-l-4 border-red-400 text-red-700 p-4 rounded-lg" role="alert">
                <p class="font-bold">Oops! Ada beberapa kesalahan:</p>
                <ul class="mt-2 list-disc list-inside text-sm">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('tasks.update', $task->id) }}" method="POST" class="space-y-6">
            @csrf
            @method('PUT')
            
            {{-- Hanya Admin yang bisa edit detail ini --}}
            @if(Auth::user()->role == 'admin')
                <div>
                    <label for="title" class="block text-sm font-medium text-gray-700 mb-1">Judul Task <span class="text-red-500">*</span></label>
                    <input type="text" name="title" id="title" class="w-full p-2 border border-gray-300 rounded-lg" value="{{ old('title', $task->title) }}" required>
                </div>

                <div>
                    <label for="description" class="block text-sm font-medium text-gray-700 mb-1">Deskripsi (Opsional)</label>
                    <textarea name="description" id="description" rows="4" class="w-full p-2 border border-gray-300 rounded-lg">{{ old('description', $task->description) }}</textarea>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="proyek_id" class="block text-sm font-medium text-gray-700 mb-1">Proyek Terkait <span class="text-red-500">*</span></label>
                        <select name="proyek_id" id="proyek_id" class="w-full p-2 border border-gray-300 rounded-lg" required>
                            @foreach($proyeks as $proyek)
                                <option value="{{ $proyek->id_proyek }}" {{ old('proyek_id', $task->proyek_id) == $proyek->id_proyek ? 'selected' : '' }}>
                                    {{ $proyek->nama_proyek }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- [DIUBAH] Menggunakan $anggota, bukan $users --}}
                    <div>
                        <label for="anggota_id" class="block text-sm font-medium text-gray-700 mb-1">Tugaskan Kepada (Anggota) <span class="text-red-500">*</span></label>
                        <select name="anggota_id" id="anggota_id" class="w-full p-2 border border-gray-300 rounded-lg" required>
                            @foreach($anggota as $member)
                                <option value="{{ $member->id }}" {{ old('anggota_id', $task->anggota_id) == $member->id ? 'selected' : '' }}>
                                    {{ $member->nama }} {{-- Asumsi kolom 'nama' di tabel anggota --}}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="priority" class="block text-sm font-medium text-gray-700 mb-1">Prioritas</label>
                        <select name="priority" id="priority" class="w-full p-2 border border-gray-300 rounded-lg">
                            <option value="Low" {{ old('priority', $task->priority) == 'Low' ? 'selected' : '' }}>Low</option>
                            <option value="Medium" {{ old('priority', $task->priority) == 'Medium' ? 'selected' : '' }}>Medium</option>
                            <option value="High" {{ old('priority', $task->priority) == 'High' ? 'selected' : '' }}>High</option>
                        </select>
                    </div>
                    <div>
                        <label for="due_date" class="block text-sm font-medium text-gray-700 mb-1">Jatuh Tempo (Opsional)</label>
                        <input type="date" name="due_date" id="due_date" class="w-full p-2 border border-gray-300 rounded-lg" value="{{ old('due_date', $task->due_date ? $task->due_date->format('Y-m-d') : '') }}">
                    </div>
                </div>
            @else
                {{-- Staff/Anggota hanya melihat detail (read-only) --}}
                <div class="space-y-4">
                    <h3 class="text-lg font-bold text-gray-800">{{ $task->title }}</h3>
                    <p class="text-gray-600 prose max-w-none">{{ $task->description ?? 'Tidak ada deskripsi.' }}</p>
                    <div class="grid grid-cols-2 gap-4 text-sm">
                        <div>
                            <span class="font-medium text-gray-500 block">Proyek:</span>
                            <span class="text-gray-800">{{ $task->proyek->nama_proyek }}</span>
                        </div>
                        <div>
                            <span class="font-medium text-gray-500 block">Jatuh Tempo:</span>
                            <span class="text-gray-800">{{ $task->due_date ? $task->due_date->format('d M Y') : '-' }}</span>
                        </div>
                    </div>
                </div>
                <hr class="my-6">
            @endif

            {{-- Bagian ini bisa diedit oleh Admin dan Anggota --}}
            <div>
                <label for="status" class="block text-sm font-medium text-gray-700 mb-1">Status Task <span class="text-red-500">*</span></label>
                <select name="status" id="status" class="w-full md:w-1/2 p-2 border border-gray-300 rounded-lg">
                    <option value="To Do" {{ old('status', $task->status) == 'To Do' ? 'selected' : '' }}>To Do</option>
                    <option value="In Progress" {{ old('status', $task->status) == 'In Progress' ? 'selected' : '' }}>In Progress</option>
                    <option value="Done" {{ old('status', $task->status) == 'Done' ? 'selected' : '' }}>Done</option>
                </select>
            </div>
            
            {{-- Tombol Aksi --}}
            <div class="flex justify-end space-x-4 pt-4 border-t border-gray-200 mt-6">
                <a href="{{ route('tasks.index') }}" class="px-4 py-2 bg-gray-300 text-gray-800 rounded-lg hover:bg-gray-400">Batal</a>
                <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">Update Task</Minta</button>
            </div>
        </form>
    </div>
</div>
@endsection