@extends('layouts.project')
@section('content')
<div class="container mx-auto max-w-4xl">
    <h1 class="text-2xl font-bold text-gray-800 mb-6">Tambah Data Klien & Legalitas</h1>

    {{-- Tampilkan Error Validasi --}}
    @if ($errors->any())
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Oops! Ada kesalahan:</strong>
            <ul class="mt-3 list-disc list-inside">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('klien.store') }}" method="POST" enctype="multipart/form-data" class="bg-white shadow-md rounded-lg p-8">
        @csrf
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            {{-- Kolom Kiri --}}
            <div>
                <div class="mb-4">
                    <label for="id_proyek" class="block text-sm font-medium text-gray-700 mb-2">Pilih Proyek</label>
                    <select id="id_proyek" name="id_proyek" class="block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500" required>
                        <option value="">-- Pilih Proyek --</option>
                        @foreach($proyeks as $proyek)
                            <option value="{{ $proyek->id_proyek }}" {{ old('id_proyek') == $proyek->id_proyek ? 'selected' : '' }}>
                                {{ $proyek->nama_proyek }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="mb-4">
                    <label for="id_user" class="block text-sm font-medium text-gray-700 mb-2">Pilih Klien (Owner)</label>
                    <select id="id_user" name="id_user" class="block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500" required>
                        <option value="">-- Pilih Klien --</option>
                        @foreach($users as $user)
                            <option value="{{ $user->id }}" {{ old('id_user') == $user->id ? 'selected' : '' }}>
                                {{ $user->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="mb-4">
                    <label for="alamat" class="block text-sm font-medium text-gray-700 mb-2">Alamat Lokasi Proyek</label>
                    <textarea id="alamat" name="alamat" rows="3" class="block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500" required>{{ old('alamat') }}</textarea>
                </div>
                
                <div class="mb-4">
                    <label for="jenis_bangunan" class="block text-sm font-medium text-gray-700 mb-2">Jenis Bangunan</label>
                    <input type="text" id="jenis_bangunan" name="jenis_bangunan" value="{{ old('jenis_bangunan') }}" class="block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500" required>
                </div>

                <div class="mb-4">
                    <label for="nomor_pbg" class="block text-sm font-medium text-gray-700 mb-2">Nomor PBG</label>
                    <input type="text" id="nomor_pbg" name="nomor_pbg" value="{{ old('nomor_pbg') }}" class="block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                </div>

                 <div class="mb-4">
                    <label for="tanggal_terbit" class="block text-sm font-medium text-gray-700 mb-2">Tanggal Terbit PBG</label>
                    <input type="date" id="tanggal_terbit" name="tanggal_terbit" value="{{ old('tanggal_terbit') }}" class="block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                </div>
            </div>

            {{-- Kolom Kanan --}}
            <div>
                <h3 class="text-lg font-medium text-gray-900 mb-4">Upload Dokumen</h3>
                
                <div class="mb-4">
                    <label for="ktp" class="block text-sm font-medium text-gray-700 mb-2">KTP Pemilik</label>
                    <input type="file" id="ktp" name="ktp" class="block w-full text-sm text-gray-900 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 focus:outline-none">
                </div>

                <div class="mb-4">
                    <label for="shm" class="block text-sm font-medium text-gray-700 mb-2">SHM (Sertifikat)</label>
                    <input type="file" id="shm" name="shm" class="block w-full text-sm text-gray-900 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 focus:outline-none">
                </div>
                
                <div class="mb-4">
                    <label for="ITR" class="block text-sm font-medium text-gray-700 mb-2">ITR (Informasi Tata Ruang)</label>
                    <input type="file" id="ITR" name="ITR" class="block w-full text-sm text-gray-900 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 focus:outline-none">
                </div>

                <div class="mb-4">
                    <label for="perhitungan_MEP" class="block text-sm font-medium text-gray-700 mb-2">Perhitungan MEP</label>
                    <input type="file" id="perhitungan_MEP" name="perhitungan_MEP" class="block w-full text-sm text-gray-900 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 focus:outline-none">
                </div>

                {{-- [BARU] Input Dinamis untuk Gambar Arsitek --}}
                <div class="mb-4 p-3 bg-gray-50 rounded-lg border" x-data="{ items: [{ id: 1 }] }">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Gambar Arsitek</label>
                    
                    <template x-for="(item, index) in items" :key="item.id">
                        <div class="flex items-center space-x-2 mb-2 p-2 border rounded bg-white">
                            <div class="flex-1">
                                <input type="file" :name="'gambar[' + index + '][file]'" class="block w-full text-sm text-gray-900 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 focus:outline-none">
                                <input type="text" :name="'gambar[' + index + '][deskripsi]'" placeholder="Deskripsi gambar..." class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm text-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                            </div>
                            <button type="button" @click="items.splice(index, 1)" class="text-red-500 hover:text-red-700 p-1">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg>
                            </button>
                        </div>
                    </template>
                    
                    <button type="button" @click="items.push({ id: Date.now() })" class="text-sm text-blue-600 hover:text-blue-800 font-medium">
                        + Tambah Gambar Arsitek
                    </button>
                </div>
               
                <div class="mb-4">
                    <label for="status" class="block text-sm font-medium text-gray-700 mb-2">Status Dokumen</label>
                    <select id="status" name="status" class="block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                        <option value="Proses" {{ old('status') == 'Proses' ? 'selected' : '' }}>Proses</option>
                        <option value="Belum Lengkap" {{ old('status') == 'Belum Lengkap' ? 'selected' : '' }}>Belum Lengkap</option>
                        <option value="Lengkap" {{ old('status') == 'Lengkap' ? 'selected' : '' }}>Lengkap</option>
                    </select>
                </div>

            </div>
        </div>

        {{-- Bagian Full-width di Bawah --}}
        <div class="mt-6">
            <label for="keterangan" class="block text-sm font-medium text-gray-700 mb-2">Keterangan Tambahan</label>
            <textarea id="keterangan" name="keterangan" rows="4" class="block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">{{ old('keterangan') }}</textarea>
        </div>

        <div class="mt-8 flex justify-end">
            <a href="{{ route('klien.index') }}" class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-bold py-2 px-4 rounded-lg mr-3">
                Batal
            </a>
            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg">
                Simpan Data Klien
            </button>
        </div>
    </form>
</div>
@endsection