@extends('layouts.Project')

@section('content')
<div class="space-y-8">
    <div>
        <h1 class="text-3xl font-bold text-gray-800">Edit Anggota</h1>
        <p class="text-gray-500 mt-1">Perbarui detail untuk: <span class="font-semibold">{{ $anggota->nama }}</span></p>
    </div>

    <div class="bg-white p-8 rounded-xl shadow-md border border-gray-200 max-w-2xl mx-auto">
        @if ($errors->any())
            <div class="mb-6 bg-red-50 border-l-4 border-red-400 text-red-700 p-4 rounded-lg" role="alert">
                <p class="font-bold">Oops! Ada beberapa kesalahan:</p>
                <ul class="mt-2 list-disc list-inside text-sm">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('anggota.update', $anggota->id) }}" method="POST" class="space-y-6">
            @csrf
            @method('PUT')
            
            <div>
                <label for="nama" class="block text-sm font-medium text-gray-700 mb-1">Nama Lengkap <span class="text-red-500">*</span></label>
                <input type="text" name="nama" id="nama" class="w-full p-2 border border-gray-300 rounded-lg" value="{{ old('nama', $anggota->nama) }}" required>
            </div>
            
            <div>
                <label for="posisi" class="block text-sm font-medium text-gray-700 mb-1">Posisi / Jabatan (Opsional)</label>
                <input type="text" name="posisi" id="posisi" class="w-full p-2 border border-gray-300 rounded-lg" value="{{ old('posisi', $anggota->posisi) }}">
            </div>

            <div>
                <label for="no_hp" class="block text-sm font-medium text-gray-700 mb-1">No. Handphone (Opsional)</label>
                <input type="text" name="no_hp" id="no_hp" class="w-full p-2 border border-gray-300 rounded-lg" value="{{ old('no_hp', $anggota->no_hp) }}">
            </div>

            {{-- Tombol Aksi --}}
            <div class="flex justify-end space-x-4 pt-4 border-t border-gray-200 mt-6">
                <a href="{{ route('anggota.index') }}" class="px-4 py-2 bg-gray-300 text-gray-800 rounded-lg hover:bg-gray-400">Batal</a>
                <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">Update Anggota</button>
            </div>
        </form>
    </div>
</div>
@endsection